/*
 * Decompiled with CFR 0.152.
 */
package com.initialde.dgttCheckDocApi.ScanDocument.application;

import com.initialde.dgttCheckDocApi.models.Document;
import com.initialde.dgttCheckDocApi.models.VerificationResult;
import com.initialde.dgttCheckDocApi.reportEvents.saveReportEvent.application.SaveReportEventHandler;
import com.initialde.dgttCheckDocApi.reportEvents.shared.domain.ReportEvent;
import com.initialde.dgttCheckDocApi.shared.infrastructure.fcm.FcmService;
import com.initialde.dgttCheckDocApi.shared.infrastructure.persistence.DocumentRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0015H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/initialde/dgttCheckDocApi/ScanDocument/application/ScanDocumentHandler;", "", "documentRepository", "Lcom/initialde/dgttCheckDocApi/shared/infrastructure/persistence/DocumentRepository;", "fcmService", "Lcom/initialde/dgttCheckDocApi/shared/infrastructure/fcm/FcmService;", "saveReportEventHandler", "Lcom/initialde/dgttCheckDocApi/reportEvents/saveReportEvent/application/SaveReportEventHandler;", "(Lcom/initialde/dgttCheckDocApi/shared/infrastructure/persistence/DocumentRepository;Lcom/initialde/dgttCheckDocApi/shared/infrastructure/fcm/FcmService;Lcom/initialde/dgttCheckDocApi/reportEvents/saveReportEvent/application/SaveReportEventHandler;)V", "getDocumentRepository", "()Lcom/initialde/dgttCheckDocApi/shared/infrastructure/persistence/DocumentRepository;", "getFcmService", "()Lcom/initialde/dgttCheckDocApi/shared/infrastructure/fcm/FcmService;", "getSaveReportEventHandler", "()Lcom/initialde/dgttCheckDocApi/reportEvents/saveReportEvent/application/SaveReportEventHandler;", "handle", "Lcom/initialde/dgttCheckDocApi/models/VerificationResult;", "Lcom/initialde/dgttCheckDocApi/models/Document;", "identificationNumber", "", "latitude", "", "longitude", "dgttCheckDocApi"})
public class ScanDocumentHandler {
    @NotNull
    private final DocumentRepository documentRepository;
    @NotNull
    private final FcmService fcmService;
    @NotNull
    private final SaveReportEventHandler saveReportEventHandler;

    public ScanDocumentHandler(@NotNull DocumentRepository documentRepository, @NotNull FcmService fcmService, @NotNull SaveReportEventHandler saveReportEventHandler) {
        Intrinsics.checkNotNullParameter((Object)documentRepository, (String)"documentRepository");
        Intrinsics.checkNotNullParameter((Object)fcmService, (String)"fcmService");
        Intrinsics.checkNotNullParameter((Object)saveReportEventHandler, (String)"saveReportEventHandler");
        this.documentRepository = documentRepository;
        this.fcmService = fcmService;
        this.saveReportEventHandler = saveReportEventHandler;
    }

    @NotNull
    public DocumentRepository getDocumentRepository() {
        return this.documentRepository;
    }

    @NotNull
    public FcmService getFcmService() {
        return this.fcmService;
    }

    @NotNull
    public SaveReportEventHandler getSaveReportEventHandler() {
        return this.saveReportEventHandler;
    }

    @NotNull
    public VerificationResult<Document> handle(@NotNull String identificationNumber, double latitude, double longitude) {
        Intrinsics.checkNotNullParameter((Object)identificationNumber, (String)"identificationNumber");
        Document document = this.getDocumentRepository().findByIdentificationNumber(identificationNumber);
        ReportEvent event = new ReportEvent(0L, "Bertrand Guizard", identificationNumber, null, latitude, longitude, null, false, null, 457, null);
        VerificationResult result = new VerificationResult(false, null, (Object)document, null, 11, null);
        if (document != null) {
            event.recognized();
            event.updateType(document.getType());
            result.found();
        }
        this.getFcmService().publish(event);
        this.getSaveReportEventHandler().handle(event);
        return result;
    }

    public static /* synthetic */ VerificationResult handle$default(ScanDocumentHandler scanDocumentHandler, String string, double d, double d2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: handle");
        }
        if ((n & 2) != 0) {
            d = 0.0;
        }
        if ((n & 4) != 0) {
            d2 = 0.0;
        }
        return scanDocumentHandler.handle(string, d, d2);
    }
}

