/*
 * Decompiled with CFR 0.152.
 */
package com.initialde.dgttCheckDocApi.config;

import com.initialde.dgttCheckDocApi.login.infrastructure.authentication.token.jwt.JwtAuthenticationFilter;
import com.initialde.dgttCheckDocApi.login.infrastructure.authentication.token.jwt.JwtService;
import com.initialde.dgttCheckDocApi.login.infrastructure.persistence.UserRepository;
import jakarta.servlet.Filter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.HttpBasicConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

@Configuration
@EnableWebSecurity
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\b\u0010\u000b\u001a\u00020\fH\u0017J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\b\u0010\u0015\u001a\u00020\u0016H\u0017J\b\u0010\u0013\u001a\u00020\u0014H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/initialde/dgttCheckDocApi/config/SecurityConfig;", "", "jwtService", "Lcom/initialde/dgttCheckDocApi/login/infrastructure/authentication/token/jwt/JwtService;", "userRepository", "Lcom/initialde/dgttCheckDocApi/login/infrastructure/persistence/UserRepository;", "(Lcom/initialde/dgttCheckDocApi/login/infrastructure/authentication/token/jwt/JwtService;Lcom/initialde/dgttCheckDocApi/login/infrastructure/persistence/UserRepository;)V", "authenticationManager", "Lorg/springframework/security/authentication/AuthenticationManager;", "authConfig", "Lorg/springframework/security/config/annotation/authentication/configuration/AuthenticationConfiguration;", "authenticationProvider", "Lorg/springframework/security/authentication/dao/DaoAuthenticationProvider;", "filterChain", "Lorg/springframework/security/web/SecurityFilterChain;", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "jwtAuthenticationFilter", "Lcom/initialde/dgttCheckDocApi/login/infrastructure/authentication/token/jwt/JwtAuthenticationFilter;", "userDetailsService", "Lorg/springframework/security/core/userdetails/UserDetailsService;", "passwordEncoder", "Lorg/springframework/security/crypto/password/PasswordEncoder;", "dgttCheckDocApi"})
public class SecurityConfig {
    @NotNull
    private final JwtService jwtService;
    @NotNull
    private final UserRepository userRepository;

    public SecurityConfig(@NotNull JwtService jwtService, @NotNull UserRepository userRepository) {
        Intrinsics.checkNotNullParameter((Object)jwtService, (String)"jwtService");
        Intrinsics.checkNotNullParameter((Object)userRepository, (String)"userRepository");
        this.jwtService = jwtService;
        this.userRepository = userRepository;
    }

    @Bean
    @NotNull
    public PasswordEncoder passwordEncoder() {
        return (PasswordEncoder)new BCryptPasswordEncoder(12);
    }

    @Bean
    @NotNull
    public UserDetailsService userDetailsService() {
        return arg_0 -> SecurityConfig.userDetailsService$lambda$1(this, arg_0);
    }

    @Bean
    @NotNull
    public AuthenticationManager authenticationManager(@NotNull AuthenticationConfiguration authConfig) {
        Intrinsics.checkNotNullParameter((Object)authConfig, (String)"authConfig");
        AuthenticationManager authenticationManager = authConfig.getAuthenticationManager();
        Intrinsics.checkNotNullExpressionValue((Object)authenticationManager, (String)"getAuthenticationManager(...)");
        return authenticationManager;
    }

    @Bean
    @NotNull
    public DaoAuthenticationProvider authenticationProvider() {
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService(this.userDetailsService());
        provider.setPasswordEncoder(this.passwordEncoder());
        return provider;
    }

    @Bean
    @NotNull
    public JwtAuthenticationFilter jwtAuthenticationFilter(@NotNull UserDetailsService userDetailsService) {
        Intrinsics.checkNotNullParameter((Object)userDetailsService, (String)"userDetailsService");
        return new JwtAuthenticationFilter(this.jwtService, userDetailsService);
    }

    @Bean
    @NotNull
    public SecurityFilterChain filterChain(@NotNull HttpSecurity http, @NotNull JwtAuthenticationFilter jwtAuthenticationFilter) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)jwtAuthenticationFilter, (String)"jwtAuthenticationFilter");
        http.csrf(SecurityConfig::filterChain$lambda$2).httpBasic(SecurityConfig::filterChain$lambda$3).sessionManagement(SecurityConfig::filterChain$lambda$4).authorizeHttpRequests(SecurityConfig::filterChain$lambda$5).addFilterBefore((Filter)jwtAuthenticationFilter, UsernamePasswordAuthenticationFilter.class);
        Object object = http.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    private static final UsernameNotFoundException userDetailsService$lambda$1$lambda$0(String $username) {
        return new UsernameNotFoundException("User not found: " + $username);
    }

    private static final UserDetails userDetailsService$lambda$1(SecurityConfig this$0, String username) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        UserRepository userRepository = this$0.userRepository;
        Intrinsics.checkNotNull((Object)username);
        com.initialde.dgttCheckDocApi.login.domain.User user = (com.initialde.dgttCheckDocApi.login.domain.User)userRepository.findByUsername(username).orElseThrow(() -> SecurityConfig.userDetailsService$lambda$1$lambda$0(username));
        String[] stringArray = new String[]{"USER"};
        return User.builder().username(user.getUsername()).password(user.getPassword()).roles(stringArray).build();
    }

    private static final void filterChain$lambda$2(CsrfConfigurer it) {
        it.disable();
    }

    private static final void filterChain$lambda$3(HttpBasicConfigurer it) {
        it.disable();
    }

    private static final void filterChain$lambda$4(SessionManagementConfigurer it) {
        it.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    private static final void filterChain$lambda$5(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry auth) {
        String[] stringArray = new String[]{"/auth/**"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(stringArray)).permitAll();
        stringArray = new String[]{"/docs/**"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry2 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry.requestMatchers(stringArray)).permitAll();
        stringArray = new String[]{"/swagger-ui-custom.html"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry3 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry2.requestMatchers(stringArray)).permitAll();
        stringArray = new String[]{"/swagger-ui/**"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry4 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry3.requestMatchers(stringArray)).permitAll();
        stringArray = new String[]{"/api/v1/auth/**"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry5 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry4.requestMatchers(stringArray)).permitAll();
        stringArray = new String[]{"/api/v1/**"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry6 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry5.requestMatchers(stringArray)).permitAll();
        stringArray = new String[]{"/files/**"};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry6.requestMatchers(stringArray)).permitAll().anyRequest()).authenticated();
    }
}

