/*
 * Decompiled with CFR 0.152.
 */
package com.initialde.dgttCheckDocApi.controllers;

import com.initialde.dgttCheckDocApi.deleteDocument.infrastructure.FileStorageService;
import com.initialde.dgttCheckDocApi.services.DocumentService;
import com.initialde.dgttCheckDocApi.services.ExcelService;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/files"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0017J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\r2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\r2\u000e\b\u0001\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/initialde/dgttCheckDocApi/controllers/FileController;", "", "fileStorageService", "Lcom/initialde/dgttCheckDocApi/deleteDocument/infrastructure/FileStorageService;", "excelService", "Lcom/initialde/dgttCheckDocApi/services/ExcelService;", "documentService", "Lcom/initialde/dgttCheckDocApi/services/DocumentService;", "(Lcom/initialde/dgttCheckDocApi/deleteDocument/infrastructure/FileStorageService;Lcom/initialde/dgttCheckDocApi/services/ExcelService;Lcom/initialde/dgttCheckDocApi/services/DocumentService;)V", "uploadDir", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getFile", "Lorg/springframework/http/ResponseEntity;", "Lorg/springframework/core/io/Resource;", "filename", "", "uploadExcel", "file", "Lorg/springframework/web/multipart/MultipartFile;", "uploadFiles", "files", "", "dgttCheckDocApi"})
public class FileController {
    @NotNull
    private final FileStorageService fileStorageService;
    @NotNull
    private final ExcelService excelService;
    @NotNull
    private final DocumentService documentService;
    private final Path uploadDir;

    public FileController(@NotNull FileStorageService fileStorageService, @NotNull ExcelService excelService, @NotNull DocumentService documentService) {
        Intrinsics.checkNotNullParameter((Object)fileStorageService, (String)"fileStorageService");
        Intrinsics.checkNotNullParameter((Object)excelService, (String)"excelService");
        Intrinsics.checkNotNullParameter((Object)documentService, (String)"documentService");
        this.fileStorageService = fileStorageService;
        this.excelService = excelService;
        this.documentService = documentService;
        this.uploadDir = Paths.get("uploads", new String[0]).toAbsolutePath().normalize();
    }

    @GetMapping(value={"/{filename:.+}"})
    @NotNull
    public ResponseEntity<Resource> getFile(@PathVariable @NotNull String filename) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Path file = this.uploadDir.resolve(filename).normalize();
        Resource resource = (Resource)new FileSystemResource(file);
        if (resource.exists()) {
            String[] stringArray = new String[]{"attachment; filename=\"" + filename + "\""};
            ResponseEntity responseEntity2 = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", stringArray)).body((Object)resource);
            Intrinsics.checkNotNull((Object)responseEntity2);
            responseEntity = responseEntity2;
        } else {
            ResponseEntity responseEntity3 = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_FOUND)).build();
            Intrinsics.checkNotNull((Object)responseEntity3);
            responseEntity = responseEntity3;
        }
        return responseEntity;
    }

    @PostMapping(value={"/upload"})
    @NotNull
    public ResponseEntity<Object> uploadFiles(@RequestParam(value="") @NotNull List<? extends MultipartFile> files) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        try {
            if (files.isEmpty()) {
                return new ResponseEntity((Object)"Aucun fichier n'a \u00e9t\u00e9 upload\u00e9", (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            List savedFileNames = this.fileStorageService.storeFiles(files);
            responseEntity = new ResponseEntity((Object)savedFileNames, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            responseEntity = new ResponseEntity((Object)("Erreur lors de l'upload : " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return responseEntity;
    }

    @PostMapping(value={"/excel"})
    @NotNull
    public ResponseEntity<Object> uploadExcel(@RequestParam(value="file") @NotNull MultipartFile file) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            InputStream inputStream = file.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            List entities = this.excelService.readExcelFile(inputStream);
            List savedEntities = this.documentService.saveAll(entities);
            responseEntity = new ResponseEntity((Object)savedEntities, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            responseEntity = new ResponseEntity((Object)("Erreur lors de l'importation : " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return responseEntity;
    }
}

