/*
 * Decompiled with CFR 0.152.
 */
package com.initialde.dgttCheckDocApi.deleteDocument.application;

import com.initialde.dgttCheckDocApi.deleteDocument.infrastructure.FileStorageService;
import com.initialde.dgttCheckDocApi.models.Document;
import com.initialde.dgttCheckDocApi.shared.infrastructure.persistence.DocumentRepository;
import jakarta.persistence.EntityNotFoundException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/initialde/dgttCheckDocApi/deleteDocument/application/DeleteDocument;", "", "documentRepository", "Lcom/initialde/dgttCheckDocApi/shared/infrastructure/persistence/DocumentRepository;", "fileStorageService", "Lcom/initialde/dgttCheckDocApi/deleteDocument/infrastructure/FileStorageService;", "(Lcom/initialde/dgttCheckDocApi/shared/infrastructure/persistence/DocumentRepository;Lcom/initialde/dgttCheckDocApi/deleteDocument/infrastructure/FileStorageService;)V", "invoke", "", "identificationNumber", "", "dgttCheckDocApi"})
@SourceDebugExtension(value={"SMAP\nDeleteDocument.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeleteDocument.kt\ncom/initialde/dgttCheckDocApi/deleteDocument/application/DeleteDocument\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,20:1\n1#2:21\n*E\n"})
public class DeleteDocument {
    @NotNull
    private final DocumentRepository documentRepository;
    @NotNull
    private final FileStorageService fileStorageService;

    public DeleteDocument(@NotNull DocumentRepository documentRepository, @NotNull FileStorageService fileStorageService) {
        Intrinsics.checkNotNullParameter((Object)documentRepository, (String)"documentRepository");
        Intrinsics.checkNotNullParameter((Object)fileStorageService, (String)"fileStorageService");
        this.documentRepository = documentRepository;
        this.fileStorageService = fileStorageService;
    }

    public void invoke(@NotNull String identificationNumber) {
        Intrinsics.checkNotNullParameter((Object)identificationNumber, (String)"identificationNumber");
        Document document = this.documentRepository.findByIdentificationNumber(identificationNumber);
        if (document == null) {
            throw new EntityNotFoundException("Document with identificationNumber " + identificationNumber + " not found");
        }
        Document existingDocument = document;
        String string = existingDocument.getImagePath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.fileStorageService.deleteFile(it);
        }
        this.documentRepository.delete(existingDocument);
    }
}

