/*
 * Decompiled with CFR 0.152.
 */
package com.initialde.dgttCheckDocApi.login.infrastructure.authentication.fake;

import com.initialde.dgttCheckDocApi.login.application.query.LoginRequest;
import com.initialde.dgttCheckDocApi.login.domain.User;
import com.initialde.dgttCheckDocApi.login.infrastructure.authentication.AuthenticationGateway;
import com.initialde.dgttCheckDocApi.login.infrastructure.authentication.token.TokenGenerator;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/initialde/dgttCheckDocApi/login/infrastructure/authentication/fake/FakeAuthenticationGateway;", "Lcom/initialde/dgttCheckDocApi/login/infrastructure/authentication/AuthenticationGateway;", "tokenGenerator", "Lcom/initialde/dgttCheckDocApi/login/infrastructure/authentication/token/TokenGenerator;", "(Lcom/initialde/dgttCheckDocApi/login/infrastructure/authentication/token/TokenGenerator;)V", "currentUser", "Lcom/initialde/dgttCheckDocApi/login/domain/User;", "authenticate", "", "loginRequest", "Lcom/initialde/dgttCheckDocApi/login/application/query/LoginRequest;", "getAuthenticatedUser", "dgttCheckDocApi"})
public final class FakeAuthenticationGateway
implements AuthenticationGateway {
    @NotNull
    private final TokenGenerator tokenGenerator;
    @Nullable
    private User currentUser;

    public FakeAuthenticationGateway(@NotNull TokenGenerator tokenGenerator) {
        Intrinsics.checkNotNullParameter((Object)tokenGenerator, (String)"tokenGenerator");
        this.tokenGenerator = tokenGenerator;
    }

    @NotNull
    public String authenticate(@NotNull LoginRequest loginRequest) {
        Intrinsics.checkNotNullParameter((Object)loginRequest, (String)"loginRequest");
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.currentUser = new User(uUID, loginRequest.getUsername(), loginRequest.getPassword());
        return this.tokenGenerator.generateToken(loginRequest);
    }

    @NotNull
    public User getAuthenticatedUser() {
        User user = this.currentUser;
        if (user == null) {
            throw new IllegalStateException("No authenticated user found");
        }
        return user;
    }
}

