/*
 * Decompiled with CFR 0.152.
 */
package com.initialde.dgttCheckDocApi.login.infrastructure.authentication.token.jwt;

import com.initialde.dgttCheckDocApi.login.application.query.LoginRequest;
import com.initialde.dgttCheckDocApi.login.infrastructure.authentication.token.TokenGenerator;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001b\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010\u0007\u001a\u00020\u00032\u0018\u0010\b\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0012J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0012J7\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\u0004\b\u0000\u0010\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0016\u0010\u0013\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0006\u0012\u0004\u0018\u0001H\u00120\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0012J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J*\u0010\u0019\u001a\u00020\u00032\u0018\u0010\b\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\fH\u0012J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0012J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0012J\u001c\u0010\u001f\u001a\u00020\u001e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\b\u0010 \u001a\u0004\u0018\u00010!H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/initialde/dgttCheckDocApi/login/infrastructure/authentication/token/jwt/JwtService;", "Lcom/initialde/dgttCheckDocApi/login/infrastructure/authentication/token/TokenGenerator;", "secretKey", "", "jwtExpirationTime", "", "(Ljava/lang/String;J)V", "buildToken", "extraClaims", "", "", "loginRequest", "Lcom/initialde/dgttCheckDocApi/login/application/query/LoginRequest;", "expirationTime", "extractAllClaims", "Lio/jsonwebtoken/Claims;", "token", "extractClaim", "T", "claimsResolver", "Ljava/util/function/Function;", "(Ljava/lang/String;Ljava/util/function/Function;)Ljava/lang/Object;", "extractExpiration", "Ljava/util/Date;", "extractUsername", "generate", "generateToken", "getSignInKey", "Ljava/security/Key;", "isTokenExpired", "", "isTokenValid", "userDetails", "Lorg/springframework/security/core/userdetails/UserDetails;", "dgttCheckDocApi"})
public class JwtService
implements TokenGenerator {
    @Nullable
    private final String secretKey;
    private final long jwtExpirationTime;

    public JwtService(@Value(value="${jwt.secret}") @Nullable String secretKey, @Value(value="${jwt.expiration}") long jwtExpirationTime) {
        this.secretKey = secretKey;
        this.jwtExpirationTime = jwtExpirationTime;
    }

    public /* synthetic */ JwtService(String string, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            l = 0L;
        }
        this(string, l);
    }

    @NotNull
    public String generateToken(@NotNull LoginRequest loginRequest) {
        Intrinsics.checkNotNullParameter((Object)loginRequest, (String)"loginRequest");
        return this.generate((Map)new HashMap(), loginRequest);
    }

    private String generate(Map<String, Object> extraClaims, LoginRequest loginRequest) {
        return this.buildToken(extraClaims, loginRequest, this.jwtExpirationTime);
    }

    private String buildToken(Map<String, Object> extraClaims, LoginRequest loginRequest, long expirationTime) {
        String string = Jwts.builder().setClaims(extraClaims).setSubject(loginRequest.getUsername()).setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(new Date(System.currentTimeMillis() + expirationTime)).signWith(this.getSignInKey(), SignatureAlgorithm.HS256).compact();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"compact(...)");
        return string;
    }

    @Nullable
    public String extractUsername(@Nullable String token) {
        return (String)this.extractClaim(token, JwtService::extractUsername$lambda$0);
    }

    public boolean isTokenValid(@Nullable String token, @Nullable UserDetails userDetails) {
        String username = this.extractUsername(token);
        UserDetails userDetails2 = userDetails;
        return StringsKt.equals$default((String)username, (String)(userDetails2 != null ? userDetails2.getUsername() : null), (boolean)false, (int)2, null) && !this.isTokenExpired(token);
    }

    @Nullable
    public <T> T extractClaim(@Nullable String token, @NotNull Function<Claims, T> claimsResolver) {
        Intrinsics.checkNotNullParameter(claimsResolver, (String)"claimsResolver");
        Claims claims = this.extractAllClaims(token);
        return claimsResolver.apply(claims);
    }

    private boolean isTokenExpired(String token) {
        Date date = this.extractExpiration(token);
        Intrinsics.checkNotNull((Object)date);
        return date.before(new Date());
    }

    private Date extractExpiration(String token) {
        return (Date)this.extractClaim(token, JwtService::extractExpiration$lambda$1);
    }

    private Claims extractAllClaims(String token) {
        Object object = Jwts.parserBuilder().setSigningKey(this.getSignInKey()).build().parseClaimsJws(token).getBody();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getBody(...)");
        return (Claims)object;
    }

    private Key getSignInKey() {
        byte[] keyBytes = (byte[])Decoders.BASE64.decode((Object)this.secretKey);
        SecretKey secretKey = Keys.hmacShaKeyFor((byte[])keyBytes);
        Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"hmacShaKeyFor(...)");
        return secretKey;
    }

    private static final String extractUsername$lambda$0(Claims it) {
        Claims claims = it;
        return claims != null ? claims.getSubject() : null;
    }

    private static final Date extractExpiration$lambda$1(Claims it) {
        Claims claims = it;
        return claims != null ? claims.getExpiration() : null;
    }

    public JwtService() {
        this(null, 0L, 3, null);
    }
}

