/*
 * Decompiled with CFR 0.152.
 */
package com.initialde.dgttCheckDocApi.services;

import com.initialde.dgttCheckDocApi.deleteDocument.infrastructure.FileStorageService;
import com.initialde.dgttCheckDocApi.models.Document;
import com.initialde.dgttCheckDocApi.models.DocumentRequest;
import com.initialde.dgttCheckDocApi.models.VerificationStatus;
import com.initialde.dgttCheckDocApi.reportEvents.shared.infrastructure.ReportEventRepository;
import com.initialde.dgttCheckDocApi.shared.infrastructure.persistence.DocumentRepository;
import jakarta.persistence.EntityNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J>\u0010\u0017\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000fH\u0016J\u0018\u0010 \u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/initialde/dgttCheckDocApi/services/DocumentService;", "", "documentRepository", "Lcom/initialde/dgttCheckDocApi/shared/infrastructure/persistence/DocumentRepository;", "fileStorageService", "Lcom/initialde/dgttCheckDocApi/deleteDocument/infrastructure/FileStorageService;", "reportEventRepository", "Lcom/initialde/dgttCheckDocApi/reportEvents/shared/infrastructure/ReportEventRepository;", "(Lcom/initialde/dgttCheckDocApi/shared/infrastructure/persistence/DocumentRepository;Lcom/initialde/dgttCheckDocApi/deleteDocument/infrastructure/FileStorageService;Lcom/initialde/dgttCheckDocApi/reportEvents/shared/infrastructure/ReportEventRepository;)V", "deleteAllDocuments", "", "deleteDocument", "identificationNumber", "", "getAllDocuments", "", "Lcom/initialde/dgttCheckDocApi/models/Document;", "getDocument", "getStatus", "Lcom/initialde/dgttCheckDocApi/models/VerificationStatus;", "documentId", "saveAll", "documents", "saveDocument", "status", "type", "additionalInfo", "", "image", "Lorg/springframework/web/multipart/MultipartFile;", "saveDocuments", "Lcom/initialde/dgttCheckDocApi/models/DocumentRequest;", "updateDocument", "updatedDocument", "dgttCheckDocApi"})
@SourceDebugExtension(value={"SMAP\nDocumentService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentService.kt\ncom/initialde/dgttCheckDocApi/services/DocumentService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1#2:95\n1549#3:96\n1620#3,3:97\n1549#3:100\n1620#3,3:101\n*S KotlinDebug\n*F\n+ 1 DocumentService.kt\ncom/initialde/dgttCheckDocApi/services/DocumentService\n*L\n36#1:96\n36#1:97,3\n50#1:100\n50#1:101,3\n*E\n"})
public class DocumentService {
    @NotNull
    private final DocumentRepository documentRepository;
    @NotNull
    private final FileStorageService fileStorageService;
    @NotNull
    private final ReportEventRepository reportEventRepository;

    public DocumentService(@NotNull DocumentRepository documentRepository, @NotNull FileStorageService fileStorageService, @NotNull ReportEventRepository reportEventRepository) {
        Intrinsics.checkNotNullParameter((Object)documentRepository, (String)"documentRepository");
        Intrinsics.checkNotNullParameter((Object)fileStorageService, (String)"fileStorageService");
        Intrinsics.checkNotNullParameter((Object)reportEventRepository, (String)"reportEventRepository");
        this.documentRepository = documentRepository;
        this.fileStorageService = fileStorageService;
        this.reportEventRepository = reportEventRepository;
    }

    @Nullable
    public VerificationStatus getStatus(@NotNull String documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Document document = this.documentRepository.findByIdentificationNumber(documentId);
        return document != null ? document.getStatus() : null;
    }

    @NotNull
    public Document saveDocument(@NotNull String identificationNumber, @NotNull String status, @NotNull String type, @NotNull Map<String, ? extends Object> additionalInfo2, @Nullable MultipartFile image) {
        String string;
        Intrinsics.checkNotNullParameter((Object)identificationNumber, (String)"identificationNumber");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(additionalInfo2, (String)"additionalInfo");
        MultipartFile multipartFile = image;
        if (multipartFile != null) {
            MultipartFile it = multipartFile;
            boolean bl = false;
            string = this.fileStorageService.storeFile(it);
        } else {
            string = null;
        }
        String imagePath = string;
        Document document = new Document(0L, identificationNumber, type, VerificationStatus.PENDING, additionalInfo2, imagePath, 1, null);
        return this.documentRepository.save(document);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Document> saveDocuments(@NotNull List<DocumentRequest> documents) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(documents, (String)"documents");
        Iterable $this$map$iv = documents;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DocumentRequest documentRequest = (DocumentRequest)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Document document = new Document(0L, it.getIdentificationNumber(), it.getType(), VerificationStatus.PENDING, it.getAdditionalInfo(), it.getImage(), 1, null);
            collection.add(this.documentRepository.save(document));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Document> saveAll(@NotNull List<Document> documents) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(documents, (String)"documents");
        Iterable $this$map$iv = documents;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Document document = (Document)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Document document2 = new Document(0L, it.getIdentificationNumber(), it.getType(), VerificationStatus.PENDING, it.getAdditionalInfo(), it.getImagePath(), 1, null);
            collection.add(this.documentRepository.save(document2));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public Document updateDocument(@NotNull String identificationNumber, @NotNull Document updatedDocument) {
        Intrinsics.checkNotNullParameter((Object)identificationNumber, (String)"identificationNumber");
        Intrinsics.checkNotNullParameter((Object)updatedDocument, (String)"updatedDocument");
        Document document = this.documentRepository.findByIdentificationNumber(identificationNumber);
        if (document == null) {
            throw new EntityNotFoundException("Document with identificationNumber " + identificationNumber + " not found");
        }
        Document existingDocument = document;
        existingDocument.setType(updatedDocument.getType());
        existingDocument.setStatus(updatedDocument.getStatus());
        existingDocument.setImagePath(updatedDocument.getImagePath());
        existingDocument.setAdditionalInfo(updatedDocument.getAdditionalInfo());
        return this.documentRepository.save(existingDocument);
    }

    public void deleteDocument(@NotNull String identificationNumber) {
        Intrinsics.checkNotNullParameter((Object)identificationNumber, (String)"identificationNumber");
        Document document = this.documentRepository.findByIdentificationNumber(identificationNumber);
        if (document == null) {
            throw new EntityNotFoundException("Document with identificationNumber " + identificationNumber + " not found");
        }
        Document existingDocument = document;
        String string = existingDocument.getImagePath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.fileStorageService.deleteFile(it);
        }
        this.documentRepository.delete(existingDocument);
    }

    @NotNull
    public List<Document> getAllDocuments() {
        return this.documentRepository.findAll();
    }

    @NotNull
    public Document getDocument(@NotNull String identificationNumber) {
        Intrinsics.checkNotNullParameter((Object)identificationNumber, (String)"identificationNumber");
        Document document = this.documentRepository.findByIdentificationNumber(identificationNumber);
        if (document == null) {
            throw new EntityNotFoundException("Document with identificationNumber " + identificationNumber + " not found");
        }
        return document;
    }

    public void deleteAllDocuments() {
        this.fileStorageService.deleteAllFiles();
        this.reportEventRepository.deleteAll();
        this.documentRepository.deleteAll();
    }
}

